/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.i2b2.eclipse.plugins.workplace.util;

import edu.harvard.i2b2.eclipse.plugins.workplace.util.StackData;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageUtil {
    private static final int MAX_STACK_SIZE = 28;
    private static MessageUtil thisInstance = new MessageUtil();
    private String request;
    private String response;
    private List<StackData> xmlStack = new ArrayList<StackData>();

    public static MessageUtil getInstance() {
        return thisInstance;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
        this.checkXmlStackSize();
        StackData stackData = new StackData();
        stackData.setMessage(request);
        stackData.setName("Sent" + this.getTimestamp());
        this.xmlStack.add(stackData);
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
        this.checkXmlStackSize();
        StackData stackData = new StackData();
        stackData.setMessage(response);
        stackData.setName("Received" + this.getTimestamp());
        this.xmlStack.add(stackData);
    }

    public List<StackData> getXmlStack() {
        return this.xmlStack;
    }

    public int getXmlStackSize() {
        return this.xmlStack.size();
    }

    public String getTimestamp() {
        Calendar cldr = Calendar.getInstance(Locale.getDefault());
        String atTimestamp = "@" + this.addZero(cldr.get(11)) + ":" + this.addZero(cldr.get(12)) + ":" + this.addZero(cldr.get(13));
        return atTimestamp;
    }

    private String addZero(int number) {
        String result = new Integer(number).toString();
        if (number < 10 && number >= 0) {
            result = "0" + result;
        }
        return result;
    }

    private void checkXmlStackSize() {
        if (this.xmlStack.size() == 28) {
            this.xmlStack.remove(0);
        }
    }
}

