/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.i2b2.eclipse.plugins.workplace.ws;

import edu.harvard.i2b2.common.exception.I2B2Exception;
import edu.harvard.i2b2.common.util.xml.XMLUtil;
import edu.harvard.i2b2.eclipse.UserInfoBean;
import edu.harvard.i2b2.eclipse.plugins.workplace.util.MessageUtil;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.AddChildRequestMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.AnnotateChildRequestMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.DeleteChildRequestMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.GetChildrenRequestMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.GetFoldersByProjectRequestMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.GetFoldersByUserIdRequestMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.MoveChildRequestMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.RenameChildRequestMessage;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.WorkplaceServiceClient;
import edu.harvard.i2b2.wkplclient.datavo.wdo.AnnotateChildType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.ChildType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.DeleteChildType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.FolderType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.GetChildrenType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.GetReturnType;
import edu.harvard.i2b2.wkplclient.datavo.wdo.RenameChildType;
import java.io.StringReader;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class WorkplaceServiceDriver {
    public static final String THIS_CLASS_NAME = WorkplaceServiceDriver.class.getName();
    private static Log log = LogFactory.getLog((String)THIS_CLASS_NAME);
    private static String serviceURL = UserInfoBean.getInstance().getCellDataUrl("work");
    private static String serviceMethod = UserInfoBean.getInstance().getCellDataMethod("work");
    private static EndpointReference soapEPR = new EndpointReference(serviceURL);
    private static EndpointReference childrenEPR = new EndpointReference(String.valueOf(serviceURL) + "getChildren");
    private static EndpointReference foldersProjectEPR = new EndpointReference(String.valueOf(serviceURL) + "getFoldersByProject");
    private static EndpointReference foldersUserIdEPR = new EndpointReference(String.valueOf(serviceURL) + "getFoldersByUserId");
    private static EndpointReference deleteEPR = new EndpointReference(String.valueOf(serviceURL) + "deleteChild");
    private static EndpointReference renameEPR = new EndpointReference(String.valueOf(serviceURL) + "renameChild");
    private static EndpointReference annotateEPR = new EndpointReference(String.valueOf(serviceURL) + "annotateChild");
    private static EndpointReference moveEPR = new EndpointReference(String.valueOf(serviceURL) + "moveChild");
    private static EndpointReference addEPR = new EndpointReference(String.valueOf(serviceURL) + "addChild");

    public static String getHomeFoldersByProject(GetReturnType returnData) throws Exception {
        String response = null;
        if (serviceURL == null || serviceMethod == null) {
            throw new I2B2Exception("Workplace Cell (WORK) not configured in PM");
        }
        try {
            GetFoldersByProjectRequestMessage reqMsg = new GetFoldersByProjectRequestMessage();
            String getFoldersRequestString = reqMsg.doBuildXML(returnData);
            if (serviceMethod.equals("SOAP")) {
                log.error((Object)"SOAP version of getFolders has not been implemented");
                response = WorkplaceServiceDriver.sendREST(foldersProjectEPR, getFoldersRequestString);
            } else {
                response = WorkplaceServiceDriver.sendREST(foldersProjectEPR, getFoldersRequestString);
            }
            log.debug((Object)("Workplace response = " + response));
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage());
            throw new AxisFault((Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new Exception(e);
        }
        return response;
    }

    public static String getHomeFoldersByUserId(GetReturnType returnData) throws Exception {
        String response = null;
        if (serviceURL == null || serviceMethod == null) {
            throw new I2B2Exception("Workplace Cell (WORK) not configured in PM");
        }
        try {
            GetFoldersByUserIdRequestMessage reqMsg = new GetFoldersByUserIdRequestMessage();
            String getFoldersRequestString = reqMsg.doBuildXML(returnData);
            log.debug((Object)getFoldersRequestString);
            if (serviceMethod.equals("SOAP")) {
                log.error((Object)"SOAP version of getFolders has not been implemented");
                response = WorkplaceServiceDriver.sendREST(foldersUserIdEPR, getFoldersRequestString);
            } else {
                response = WorkplaceServiceDriver.sendREST(foldersUserIdEPR, getFoldersRequestString);
            }
            log.debug((Object)("Workplace response = " + response));
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage());
            throw new AxisFault((Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new Exception(e);
        }
        return response;
    }

    public static String getChildren(GetChildrenType parentNode) throws Exception {
        String response = null;
        try {
            GetChildrenRequestMessage reqMsg = new GetChildrenRequestMessage();
            String getChildrenRequestString = reqMsg.doBuildXML(parentNode);
            log.debug((Object)getChildrenRequestString);
            if (serviceMethod.equals("SOAP")) {
                log.error((Object)"SOAP version of getChildren has not been implemented");
                response = WorkplaceServiceDriver.sendREST(childrenEPR, getChildrenRequestString);
            } else {
                response = WorkplaceServiceDriver.sendREST(childrenEPR, getChildrenRequestString);
            }
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage());
            throw new AxisFault((Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new Exception(e);
        }
        return response;
    }

    public static String deleteChild(DeleteChildType childNode) throws Exception {
        String response = null;
        try {
            DeleteChildRequestMessage reqMsg = new DeleteChildRequestMessage();
            String deleteChildRequestString = reqMsg.doBuildXML(childNode);
            log.debug((Object)deleteChildRequestString);
            if (serviceMethod.equals("SOAP")) {
                log.error((Object)"SOAP version of deleteChild has not been implemented");
                response = WorkplaceServiceDriver.sendREST(deleteEPR, deleteChildRequestString);
            } else {
                response = WorkplaceServiceDriver.sendREST(deleteEPR, deleteChildRequestString);
            }
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage());
            throw new AxisFault((Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new Exception(e);
        }
        return response;
    }

    public static String moveChild(ChildType childNode) throws Exception {
        String response = null;
        try {
            MoveChildRequestMessage reqMsg = new MoveChildRequestMessage();
            String requestString = reqMsg.doBuildXML(childNode);
            if (serviceMethod.equals("SOAP")) {
                log.error((Object)"SOAP version of cleanupChildren has not been implemented");
                response = WorkplaceServiceDriver.sendREST(moveEPR, requestString);
            } else {
                response = WorkplaceServiceDriver.sendREST(moveEPR, requestString);
            }
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage());
            throw new AxisFault((Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new Exception(e);
        }
        return response;
    }

    public static String renameChild(RenameChildType childNode) throws Exception {
        String response = null;
        try {
            RenameChildRequestMessage reqMsg = new RenameChildRequestMessage();
            String renameChildRequestString = reqMsg.doBuildXML(childNode);
            log.debug((Object)renameChildRequestString);
            if (serviceMethod.equals("SOAP")) {
                log.error((Object)"SOAP version of renameChild has not been implemented");
                response = WorkplaceServiceDriver.sendREST(renameEPR, renameChildRequestString);
            } else {
                response = WorkplaceServiceDriver.sendREST(renameEPR, renameChildRequestString);
            }
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage());
            throw new AxisFault((Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new Exception(e);
        }
        return response;
    }

    public static String annotateChild(AnnotateChildType childNode) throws Exception {
        String response = null;
        try {
            AnnotateChildRequestMessage reqMsg = new AnnotateChildRequestMessage();
            String annotateChildRequestString = reqMsg.doBuildXML(childNode);
            log.debug((Object)annotateChildRequestString);
            if (serviceMethod.equals("SOAP")) {
                log.error((Object)"SOAP version of annotateChild has not been implemented");
                response = WorkplaceServiceDriver.sendREST(annotateEPR, annotateChildRequestString);
            } else {
                response = WorkplaceServiceDriver.sendREST(annotateEPR, annotateChildRequestString);
            }
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage());
            throw new AxisFault((Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new Exception(e);
        }
        return response;
    }

    public static String addChild(FolderType childNode) throws Exception {
        String response = null;
        try {
            AddChildRequestMessage reqMsg = new AddChildRequestMessage();
            String addChildRequestString = reqMsg.doBuildXML(childNode);
            log.debug((Object)addChildRequestString);
            if (serviceMethod.equals("SOAP")) {
                log.error((Object)"SOAP version of addChild has not been implemented");
                response = WorkplaceServiceDriver.sendREST(addEPR, addChildRequestString);
            } else {
                response = WorkplaceServiceDriver.sendREST(addEPR, addChildRequestString);
            }
        }
        catch (AxisFault e) {
            log.error((Object)e.getMessage());
            throw new AxisFault((Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new Exception(e);
        }
        return response;
    }

    public static OMElement getWorkPayLoad(String requestWdo) throws Exception {
        OMElement lineItem = null;
        try {
            StringReader strReader = new StringReader(requestWdo);
            XMLInputFactory xif = XMLInputFactory.newInstance();
            XMLStreamReader reader = xif.createXMLStreamReader(strReader);
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            lineItem = builder.getDocumentElement();
        }
        catch (FactoryConfigurationError e) {
            log.error((Object)e.getMessage());
            throw new Exception(e);
        }
        return lineItem;
    }

    public static String sendREST(EndpointReference restEPR, String requestString) throws Exception {
        if (UserInfoBean.getInstance().getCellDataUrl("work") == null) {
            throw new I2B2Exception("Workplace cell (WORK) not configured in PM");
        }
        OMElement getWork = WorkplaceServiceDriver.getWorkPayLoad(requestString);
        MessageUtil.getInstance().setRequest("URL: " + restEPR + "\n" + getWork.toString());
        Options options = new Options();
        log.debug((Object)restEPR.toString());
        options.setTo(restEPR);
        options.setTransportInProtocol("http");
        options.setProperty("enableREST", (Object)"true");
        options.setProperty("SO_TIMEOUT", (Object)new Integer(125000));
        options.setProperty("CONNECTION_TIMEOUT", (Object)new Integer(125000));
        ServiceClient sender = WorkplaceServiceClient.getServiceClient();
        sender.setOptions(options);
        OMElement result = sender.sendReceive(getWork);
        String response = result.toString();
        MessageUtil.getInstance().setResponse("URL: " + restEPR + "\n" + response);
        return response;
    }

    public static String sendSOAP(String requestString, String action, String operation, String type) throws Exception {
        ServiceClient sender = WorkplaceServiceClient.getServiceClient();
        OperationClient operationClient = sender.createClient(ServiceClient.ANON_OUT_IN_OP);
        MessageContext outMsgCtx = new MessageContext();
        Options opts = outMsgCtx.getOptions();
        log.debug((Object)soapEPR);
        opts.setTo(soapEPR);
        opts.setAction(action);
        opts.setTimeOutInMilliSeconds(180000L);
        log.debug((Object)requestString);
        SOAPEnvelope envelope = null;
        try {
            SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
            envelope = fac.getDefaultEnvelope();
            OMNamespace omNs = fac.createOMNamespace("http://rpdr.partners.org/", "rpdr");
            OMElement method = fac.createOMElement(operation, omNs);
            OMElement value = fac.createOMElement("RequestXmlString", omNs);
            value.setText(requestString);
            method.addChild((OMNode)value);
            envelope.getBody().addChild((OMNode)method);
        }
        catch (FactoryConfigurationError e) {
            log.error((Object)e.getMessage());
            throw new Exception(e);
        }
        outMsgCtx.setEnvelope(envelope);
        if (type != null) {
            String request = envelope.toString();
            String formattedRequest = XMLUtil.StrFindAndReplace((String)"&lt;", (String)"<", (String)request);
            MessageUtil.getInstance().setRequest("URL: " + soapEPR + "\n" + formattedRequest);
        }
        operationClient.addMessageContext(outMsgCtx);
        operationClient.execute(true);
        MessageContext inMsgtCtx = operationClient.getMessageContext("In");
        SOAPEnvelope responseEnv = inMsgtCtx.getEnvelope();
        OMElement soapResponse = responseEnv.getBody().getFirstElement();
        if (type != null) {
            String formattedResponse = XMLUtil.StrFindAndReplace((String)"&lt;", (String)"<", (String)responseEnv.toString());
            String indentedResponse = XMLUtil.convertDOMToString((Document)XMLUtil.convertStringToDOM((String)formattedResponse));
            MessageUtil.getInstance().setResponse("URL: " + soapEPR + "\n" + indentedResponse);
        }
        OMElement soapResult = soapResponse.getFirstElement();
        String i2b2Response = soapResult.getText();
        log.debug((Object)i2b2Response);
        return i2b2Response;
    }
}

