/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.i2b2.eclipse.plugins.workplace.views;

import edu.harvard.i2b2.common.util.jaxb.JAXBUtilException;
import edu.harvard.i2b2.eclipse.plugins.workplace.util.WorkplaceJAXBUtil;
import edu.harvard.i2b2.eclipse.plugins.workplace.views.TreeData;
import edu.harvard.i2b2.eclipse.plugins.workplace.views.TreeNode;
import edu.harvard.i2b2.wkplclient.datavo.dnd.DndType;
import edu.harvard.i2b2.wkplclient.datavo.dnd.ObjectFactory;
import edu.harvard.i2b2.wkplclient.datavo.wdo.FoldersType;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;

final class NodeDragListener
implements DragSourceListener {
    private Log log = LogFactory.getLog((String)NodeDragListener.class.getName());
    private final TreeViewer viewer;
    private IStructuredSelection selectionOnDrag = null;

    NodeDragListener(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void dragStart(DragSourceEvent event) {
        for (TreeNode node : (IStructuredSelection)this.viewer.getSelection()) {
            TreeData data = node.getData();
            if (!data.getVisualAttributes().substring(0, 1).equals("C")) continue;
            event.doit = false;
            event.detail = 0;
            return;
        }
        this.selectionOnDrag = (IStructuredSelection)this.viewer.getSelection();
        event.doit = true;
    }

    public void dragSetData(DragSourceEvent event) {
        Iterator iterator = this.selectionOnDrag.iterator();
        TreeNode node = (TreeNode)iterator.next();
        TreeData workData = node.getData();
        if (workData.getVisualAttributes().startsWith("F")) {
            StringWriter strWriter = null;
            FoldersType folders = new FoldersType();
            folders.getFolder().add(workData);
            try {
                strWriter = new StringWriter();
                DndType dnd = new DndType();
                edu.harvard.i2b2.wkplclient.datavo.wdo.ObjectFactory wdoOf = new edu.harvard.i2b2.wkplclient.datavo.wdo.ObjectFactory();
                dnd.getAny().add(wdoOf.createFolders(folders));
                ObjectFactory of = new ObjectFactory();
                WorkplaceJAXBUtil.getJAXBUtil().marshaller(of.createPluginDragDrop(dnd), (Writer)strWriter);
            }
            catch (JAXBUtilException jAXBUtilException) {
                this.log.error((Object)"Error marshalling Workplace drag text");
            }
            event.data = strWriter.toString();
        } else {
            org.w3c.dom.Element dndElement = workData.getWorkXml().getAny().get(0);
            try {
                DOMBuilder builder = new DOMBuilder();
                Element jdomElement = builder.build(dndElement);
                event.data = new XMLOutputter().outputString(jdomElement);
            }
            catch (Exception exception) {
                this.log.error((Object)"Error marshalling Workplace drag text");
            }
        }
        event.display.setData((Object)workData);
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.display.getData() != null && event.display.getData().getClass().equals(String.class)) {
            Iterator iterator = this.selectionOnDrag.iterator();
            TreeNode node = (TreeNode)iterator.next();
            if (event.display.getData().equals("M|O*V+E")) {
                ((TreeNode)node.getParent()).getChildren().remove(node);
            } else {
                node.copyChildren((String)event.display.getData());
            }
        }
        event.display.setData(null);
        this.selectionOnDrag = null;
        this.viewer.refresh();
    }
}

