/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.i2b2.eclipse.plugins.workplace.views;

import edu.harvard.i2b2.eclipse.UserInfoBean;
import edu.harvard.i2b2.eclipse.plugins.workplace.views.NodeDragListener;
import edu.harvard.i2b2.eclipse.plugins.workplace.views.NodeDropListener;
import edu.harvard.i2b2.eclipse.plugins.workplace.views.TreeData;
import edu.harvard.i2b2.eclipse.plugins.workplace.views.TreeNode;
import edu.harvard.i2b2.eclipse.plugins.workplace.ws.AddChildRequestMessage;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class NodeBrowser
extends ApplicationWindow {
    private Log log = LogFactory.getLog((String)NodeBrowser.class.getName());
    private TreeViewer viewer;
    private TreeData currentData;
    public TreeNode rootNode;
    private ImageRegistry imageRegistry;
    private Menu menu;
    private Menu folderMenu;
    private Menu caseMenu;

    public NodeBrowser(Composite parent, int inputFlag, StatusLineManager slm) {
        super(null);
        ArrayList roles = (ArrayList)UserInfoBean.getInstance().getProjectRoles();
        for (String param : roles) {
            if (!param.equalsIgnoreCase("manager")) continue;
            System.setProperty("WPManager", String.valueOf(true));
            break;
        }
        this.imageRegistry = new ImageRegistry();
        this.createImageRegistry();
        this.createTreeViewer(parent, 2048, inputFlag);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        this.viewer.addDragSupport(1, types, (DragSourceListener)new NodeDragListener(this.viewer));
        this.viewer.addDropSupport(19, types, (DropTargetListener)new NodeDropListener(this.viewer));
    }

    private void createImageRegistry() {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/leaf.jpg");
        this.imageRegistry.put("leaf", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/multi.bmp");
        this.imageRegistry.put("multi", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/openFolder.jpg");
        this.imageRegistry.put("openFolder", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/openCase.jpg");
        this.imageRegistry.put("openCase", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/closedFolder.jpg");
        this.imageRegistry.put("closedFolder", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/closedCase.jpg");
        this.imageRegistry.put("closedCase", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/concept.jpg");
        this.imageRegistry.put("concept", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/conceptFA.jpg");
        this.imageRegistry.put("conceptFA", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/patient_coll.jpg");
        this.imageRegistry.put("patient_coll", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/xml_results.jpg");
        this.imageRegistry.put("xml_results", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/patient_count_xml.jpg");
        this.imageRegistry.put("patient_count_xml", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/prev_query.jpg");
        this.imageRegistry.put("prev_query", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/query_definition.jpg");
        this.imageRegistry.put("query_definition", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/group_template.jpg");
        this.imageRegistry.put("group_template", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/observation.png");
        this.imageRegistry.put("observation", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/patient.jpg");
        this.imageRegistry.put("patient", imageDescriptor);
        imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/patient.jpg");
        this.imageRegistry.put("pdo", imageDescriptor);
    }

    private void createTreeViewer(Composite parent, int style, int inputFlag) {
        Tree tree = new Tree(parent, style);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 50;
        gridData.horizontalSpan = 2;
        gridData.widthHint = 150;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData);
        MenuManager popupMenu = new MenuManager();
        RenameAction renameAction = new RenameAction();
        AnnotateAction annotateAction = new AnnotateAction();
        DeleteAction deleteAction = new DeleteAction();
        popupMenu.add((IAction)renameAction);
        popupMenu.add((IAction)annotateAction);
        popupMenu.add((IAction)deleteAction);
        this.menu = popupMenu.createContextMenu((Control)tree);
        MenuManager casePopupMenu = new MenuManager();
        NewFolderAction makeFolderAction = new NewFolderAction();
        casePopupMenu.add((IAction)makeFolderAction);
        this.caseMenu = casePopupMenu.createContextMenu((Control)tree);
        MenuManager folderPopupMenu = new MenuManager();
        folderPopupMenu.add((IAction)renameAction);
        folderPopupMenu.add((IAction)annotateAction);
        folderPopupMenu.add((IAction)deleteAction);
        folderPopupMenu.add((IAction)makeFolderAction);
        this.folderMenu = folderPopupMenu.createContextMenu((Control)tree);
        this.viewer = new TreeViewer(tree);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                TreeItem item = (TreeItem)NodeBrowser.this.viewer.testFindItem((Object)((TreeNode)element));
                String tooltip = ((TreeNode)element).getData().getTooltip();
                if (tooltip == null || tooltip.equals("")) {
                    tooltip = ((TreeNode)element).toString();
                }
                tooltip = " " + tooltip + " ";
                item.setData("TOOLTIP", (Object)tooltip);
                if (((TreeNode)element).getData().getVisualAttributes().substring(1, 2).equals("I")) {
                    Color color = Display.getCurrent().getSystemColor(16);
                    item.setForeground(color);
                } else if (((TreeNode)element).getData().getVisualAttributes().substring(1, 2).equals("H")) {
                    Color color = Display.getCurrent().getSystemColor(3);
                    item.setForeground(color);
                } else if (((TreeNode)element).getData().getVisualAttributes().equals("C-ERROR")) {
                    Color color = Display.getCurrent().getSystemColor(3);
                    item.setForeground(color);
                }
                return ((TreeNode)element).toString();
            }

            public Image getImage(Object element) {
                return NodeBrowser.this.imageRegistry.get(((TreeNode)element).getIconKey());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return ((TreeNode)parentElement).getChildren().toArray();
            }

            public Object getParent(Object element) {
                return ((TreeNode)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((TreeNode)element).getChildren().size() > 0;
            }

            public Object[] getElements(Object inputElement) {
                return ((TreeNode)inputElement).getChildren().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setInput((Object)this.populateRootNode());
        String status = System.getProperty("errorMessage");
        if (status != null) {
            TreeNode placeholder = new TreeNode("placeholder", status, "C-ERROR");
            this.rootNode.addChild(placeholder);
            this.refresh();
            System.setProperty("errorMessage", "");
        }
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreeNode node = (TreeNode)event.getElement();
                if (node.getData().getVisualAttributes().equals("FA")) {
                    node.getData().setVisualAttributes("FAO");
                } else if (node.getData().getVisualAttributes().equals("CA")) {
                    node.getData().setVisualAttributes("CAO");
                } else if (node.getData().getVisualAttributes().equals("FH")) {
                    node.getData().setVisualAttributes("FHO");
                } else if (node.getData().getVisualAttributes().equals("CH")) {
                    node.getData().setVisualAttributes("CHO");
                }
                if (node.getChildren().size() > 0) {
                    TreeNode firstChild = (TreeNode)node.getChildren().get(0);
                    if (firstChild.getData().getVisualAttributes().equals("LAO") || firstChild.getData().getVisualAttributes().equals("LHO")) {
                        node.getXMLData(NodeBrowser.this.viewer).start();
                    } else {
                        int i = 0;
                        while (i < node.getChildren().size()) {
                            TreeNode child = (TreeNode)node.getChildren().get(i);
                            if (child.getData().getVisualAttributes().equals("FAO")) {
                                child.getData().setVisualAttributes("FA");
                            } else if (child.getData().getVisualAttributes().equals("CAO")) {
                                child.getData().setVisualAttributes("CA");
                            } else if (child.getData().getVisualAttributes().equals("FHO")) {
                                child.getData().setVisualAttributes("FH");
                            } else if (child.getData().getVisualAttributes().equals("CHO")) {
                                child.getData().setVisualAttributes("CH");
                            }
                            ++i;
                        }
                    }
                }
                NodeBrowser.this.viewer.refresh();
                NodeBrowser.this.viewer.expandToLevel((Object)node, 1);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                TreeNode node = (TreeNode)event.getElement();
                if (node.getData().getVisualAttributes().equals("FAO")) {
                    node.getData().setVisualAttributes("FA");
                } else if (node.getData().getVisualAttributes().equals("CAO")) {
                    node.getData().setVisualAttributes("CA");
                } else if (node.getData().getVisualAttributes().equals("FHO")) {
                    node.getData().setVisualAttributes("FH");
                } else if (node.getData().getVisualAttributes().equals("CHO")) {
                    node.getData().setVisualAttributes("CH");
                }
                NodeBrowser.this.viewer.collapseToLevel((Object)node, 1);
                NodeBrowser.this.viewer.refresh();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeNode node = null;
                if (event.getSelection().isEmpty()) {
                    NodeBrowser.this.setCurrentNode(null);
                    return;
                }
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    node = (TreeNode)selection.getFirstElement();
                    NodeBrowser.this.setCurrentNode(node);
                }
                boolean expand = false;
                if (node.getData().getVisualAttributes().equals("FA")) {
                    node.getData().setVisualAttributes("FAO");
                    expand = true;
                } else if (node.getData().getVisualAttributes().equals("CA")) {
                    node.getData().setVisualAttributes("CAO");
                    expand = true;
                } else if (node.getData().getVisualAttributes().equals("FH")) {
                    node.getData().setVisualAttributes("FHO");
                    expand = true;
                } else if (node.getData().getVisualAttributes().equals("CH")) {
                    node.getData().setVisualAttributes("CHO");
                    expand = true;
                }
                if (expand) {
                    NodeBrowser.this.viewer.expandToLevel((Object)node, 1);
                    NodeBrowser.this.viewer.refresh((Object)node);
                    if (node.getChildren().size() > 0) {
                        TreeNode firstChild = (TreeNode)node.getChildren().get(0);
                        if (firstChild.getData().getVisualAttributes().equals("LAO") || firstChild.getData().getVisualAttributes().equals("LHO")) {
                            node.getXMLData(NodeBrowser.this.viewer).start();
                        } else {
                            int i = 0;
                            while (i < node.getChildren().size()) {
                                TreeNode child = (TreeNode)node.getChildren().get(i);
                                if (child.getData().getVisualAttributes().equals("FAO")) {
                                    child.getData().setVisualAttributes("FA");
                                } else if (child.getData().getVisualAttributes().equals("CAO")) {
                                    child.getData().setVisualAttributes("CA");
                                } else if (child.getData().getVisualAttributes().equals("FHO")) {
                                    child.getData().setVisualAttributes("FH");
                                } else if (child.getData().getVisualAttributes().equals("CHO")) {
                                    child.getData().setVisualAttributes("CH");
                                }
                                ++i;
                            }
                            NodeBrowser.this.viewer.refresh();
                        }
                    }
                } else if (node.getData().getVisualAttributes().equals("FAO")) {
                    node.getData().setVisualAttributes("FA");
                    NodeBrowser.this.viewer.collapseToLevel((Object)node, 1);
                    NodeBrowser.this.viewer.refresh((Object)node);
                } else if (node.getData().getVisualAttributes().equals("CAO")) {
                    node.getData().setVisualAttributes("CA");
                    NodeBrowser.this.viewer.collapseToLevel((Object)node, 1);
                    NodeBrowser.this.viewer.refresh((Object)node);
                } else if (node.getData().getVisualAttributes().equals("FHO")) {
                    node.getData().setVisualAttributes("FH");
                    NodeBrowser.this.viewer.collapseToLevel((Object)node, 1);
                    NodeBrowser.this.viewer.refresh((Object)node);
                } else if (node.getData().getVisualAttributes().equals("CHO")) {
                    node.getData().setVisualAttributes("CH");
                    NodeBrowser.this.viewer.collapseToLevel((Object)node, 1);
                    NodeBrowser.this.viewer.refresh((Object)node);
                }
            }
        });
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData("_TREEITEM");
                        NodeBrowser.this.viewer.getTree().setSelection(new TreeItem[]{(TreeItem)e.item});
                        NodeBrowser.this.viewer.getTree().notifyListeners(13, e);
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener viewerListener = new Listener(){
            Shell tip = null;
            Label label = null;

            /*
             * Unable to fully structure code
             */
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 3: 
                    case 12: {
                        if (event.button != 3) ** GOTO lbl19
                        selection = (IStructuredSelection)NodeBrowser.access$0(NodeBrowser.this).getSelection();
                        if (selection.size() != 1) {
                            return;
                        }
                        node = (TreeNode)selection.getFirstElement();
                        if (!node.getData().getVisualAttributes().equals("LA")) ** GOTO lbl11
                        NodeBrowser.access$2(NodeBrowser.this).setVisible(true);
                        ** GOTO lbl19
lbl11:
                        // 1 sources

                        if (!node.getData().getVisualAttributes().startsWith("ZA")) ** GOTO lbl14
                        NodeBrowser.access$2(NodeBrowser.this).setVisible(true);
                        ** GOTO lbl19
lbl14:
                        // 1 sources

                        if (!node.getData().getVisualAttributes().startsWith("F")) ** GOTO lbl17
                        NodeBrowser.access$3(NodeBrowser.this).setVisible(true);
                        ** GOTO lbl19
lbl17:
                        // 1 sources

                        if (node.getData().getVisualAttributes().startsWith("C")) {
                            NodeBrowser.access$4(NodeBrowser.this).setVisible(true);
                        }
                    }
lbl19:
                    // 8 sources

                    case 5: 
                    case 7: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        item = NodeBrowser.access$0(NodeBrowser.this).getTree().getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(Display.getCurrent().getActiveShell(), 16388);
                        this.tip.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(Display.getCurrent().getSystemColor(28));
                        this.label.setBackground(Display.getCurrent().getSystemColor(29));
                        this.label.setData("_TREEITEM", (Object)item);
                        this.label.setText((String)item.getData("TOOLTIP"));
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        size = this.tip.computeSize(-1, -1);
                        item.getBounds(0);
                        pt = NodeBrowser.access$0(NodeBrowser.this).getTree().toDisplay(event.x, event.y);
                        this.tip.setBounds(pt.x + 10, pt.y + 20, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        this.viewer.getTree().addListener(3, viewerListener);
        this.viewer.getTree().addListener(12, viewerListener);
        this.viewer.getTree().addListener(1, viewerListener);
        this.viewer.getTree().addListener(5, viewerListener);
        this.viewer.getTree().addListener(32, viewerListener);
        this.viewer.getTree().addListener(7, viewerListener);
    }

    public void setCurrentNode(TreeNode node) {
        this.currentData = node.getData();
    }

    public void addNodes(TreeData data) {
        this.currentData = data;
        TreeNode child = new TreeNode(data);
        this.viewer.setInput((Object)child);
    }

    public TreeData getSelectedNode() {
        return this.currentData;
    }

    public void refresh() {
        this.viewer.refresh((Object)this.rootNode);
    }

    public void flush() {
        this.rootNode.getChildren().clear();
    }

    private TreeNode populateRootNode() {
        TreeNode root = new TreeNode("home", "home", "CA");
        root.getHomeFolders(this.viewer);
        this.rootNode = root;
        return root;
    }

    static /* synthetic */ Menu access$2(NodeBrowser nodeBrowser) {
        return nodeBrowser.menu;
    }

    static /* synthetic */ Menu access$3(NodeBrowser nodeBrowser) {
        return nodeBrowser.folderMenu;
    }

    static /* synthetic */ Menu access$4(NodeBrowser nodeBrowser) {
        return nodeBrowser.caseMenu;
    }

    private class AnnotateAction
    extends Action {
        public AnnotateAction() {
            super("Annotate");
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)NodeBrowser.this.viewer.getSelection();
            if (selection.size() != 1) {
                return;
            }
            TreeNode node = (TreeNode)selection.getFirstElement();
            if (Boolean.parseBoolean(System.getProperty("WPManager")) || node.getData().getUserId().equals(UserInfoBean.getInstance().getUserName())) {
                node.annotateNode(NodeBrowser.this.viewer).start();
                NodeBrowser.this.viewer.refresh();
            } else {
                MessageBox mBox = new MessageBox(Display.getCurrent().getActiveShell(), 34);
                mBox.setText("Annotate Node Message");
                mBox.setMessage("You do not have permission to annotate this node");
                mBox.open();
            }
        }
    }

    private class DeleteAction
    extends Action {
        public DeleteAction() {
            super("Delete");
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)NodeBrowser.this.viewer.getSelection();
            if (selection.size() != 1) {
                return;
            }
            TreeNode node = (TreeNode)selection.getFirstElement();
            if (Boolean.parseBoolean(System.getProperty("WPManager")) || node.getData().getUserId().equals(UserInfoBean.getInstance().getUserName())) {
                int result = 128;
                if (node.getData().getVisualAttributes().startsWith("F")) {
                    MessageBox mBox = new MessageBox(Display.getCurrent().getActiveShell(), 196);
                    mBox.setText("Delete Node Dialog");
                    mBox.setMessage("Deleting a folder will delete its contents also\nDelete folder \"" + node.getData().getName() + "\"?\n");
                    result = mBox.open();
                } else {
                    MessageBox mBox = new MessageBox(Display.getCurrent().getActiveShell(), 196);
                    mBox.setText("Delete Node Dialog");
                    mBox.setMessage("Delete node \"" + node.getData().getName() + "\"?\n");
                    result = mBox.open();
                }
                if (result == 128) {
                    return;
                }
                node.deleteNode(NodeBrowser.this.viewer).start();
            } else {
                MessageBox mBox = new MessageBox(Display.getCurrent().getActiveShell(), 34);
                mBox.setText("Delete Node Message");
                mBox.setMessage("You do not have permission to delete this node");
                mBox.open();
            }
        }
    }

    private class NewFolderAction
    extends Action {
        public NewFolderAction() {
            super("New Folder");
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)NodeBrowser.this.viewer.getSelection();
            if (selection.size() != 1) {
                return;
            }
            TreeNode currentTarget = (TreeNode)selection.getFirstElement();
            TreeData tdata = new TreeData();
            tdata.setName("New Folder");
            tdata.setTooltip("FOLDER:New Folder");
            tdata.setIndex(new AddChildRequestMessage().generateMessageId());
            tdata.setParentIndex(currentTarget.getData().getIndex());
            tdata.setVisualAttributes("FA");
            tdata.setWorkXml(null);
            tdata.setWorkXmlI2B2Type("FOLDER");
            tdata.setUserId(UserInfoBean.getInstance().getUserName());
            tdata.setGroupId(currentTarget.getData().getGroupId());
            tdata.setShareId(currentTarget.getData().getShareId());
            tdata.setWorkXmlSchema(null);
            tdata.setEntryDate(null);
            tdata.setChangeDate(null);
            tdata.setStatusCd(null);
            tdata.setTableCd(currentTarget.getData().getTableCd());
            TreeNode child = new TreeNode(tdata);
            currentTarget.addChild(child);
            child.addNode(NodeBrowser.this.viewer).start();
            NodeBrowser.this.viewer.refresh();
        }
    }

    private class RenameAction
    extends Action {
        public RenameAction() {
            super("Rename");
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)NodeBrowser.this.viewer.getSelection();
            if (selection.size() != 1) {
                return;
            }
            TreeNode node = (TreeNode)selection.getFirstElement();
            if (Boolean.parseBoolean(System.getProperty("WPManager")) || node.getData().getUserId().equals(UserInfoBean.getInstance().getUserName())) {
                node.renameNode(NodeBrowser.this.viewer).start();
                NodeBrowser.this.viewer.refresh();
            } else {
                MessageBox mBox = new MessageBox(Display.getCurrent().getActiveShell(), 34);
                mBox.setText("Rename Node Message");
                mBox.setMessage("You do not have permission to rename this node");
                mBox.open();
            }
        }
    }
}

