<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="*">
		<xsl:apply-templates select="variables"/>
	</xsl:template>
	<xsl:template match="/variables">
		<xsl:element name="source">
			<xsl:element name="name">briccs</xsl:element>
			<!-- only interested in variable elements with a child of categories -->
			<xsl:apply-templates select="variable[categories]"/>
		</xsl:element>
	</xsl:template>
	<!-- only want one stage element and subsequent section etc so apply only when it's the first in the list rather than all of them -->
	<xsl:template match="variable[categories][position()=1]">
		<xsl:element name="stage">
			<xsl:element name="name">
				<xsl:value-of select="attributes/attribute[@name='stage']"/>
			</xsl:element>
			<xsl:element name="section">
				<xsl:element name="name">
					<xsl:value-of select="attributes/attribute[@name='section']"/>
				</xsl:element>
				<!-- to get the depth right we now need to go up the tree and get all the variables with categories and loop thru them -->
				<xsl:for-each select="//variable[categories]">
					<xsl:element name="question">
						<xsl:element name="name">
							<xsl:value-of select="@name"/>
						</xsl:element>
						<xsl:element name="label">
							<xsl:value-of select="attributes/attribute[@name='label']"/>
						</xsl:element>
						<!-- now get all the categories below where we are -->
						<xsl:apply-templates select="categories"/>
					</xsl:element>
				</xsl:for-each>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<xsl:template match="categories">
		<xsl:element name="variable">
			<xsl:element name="name">
				<xsl:value-of select="../attributes/attribute[@name='questionName']"/>
			</xsl:element>
			<xsl:element name="type">
				<xsl:value-of select="../@valueType"/>
			</xsl:element>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
